//
//  main.cpp
//  fp64
//
//  Created by Bob Delaney on 11/30/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#include <iostream>
#include "fp.hpp"
#include "fpMath.hpp"
#include "fpConv.hpp"

fp  t, *f, *x, *xt, *k1, *k2, *k3, *k4;

/*
  dx0/dt = f0 = x1
  dx1/dt = f1 = -x0
  so
  d2x0/dt2 = -x0
 SHO  x0 = sin(t) ; x1 = cos(t) ; f0 = cos(t) ; f1 = -sin(t) ;
 */
static void funcArray(long n)
{
    f[0] = x[1];
    f[1] = -x[0];
    
}/* funcArray */

static void rkn(long n, const fp& h)
{
    long    i;
    
    for(i=0;i<n;++i)
        xt[i] = x[i];
    
    funcArray(n);
    for(i=0;i<n;++i)
    {
        k1[i] = h * f[i];
        x[i] = xt[i] + k1[i] / 2;
    }
    
    t = t + h / 2;
    funcArray(n);
    for(i=0;i<n;++i)
    {
        k2[i] = h * f[i];
        x[i] = xt[i] + k2[i] / 2;
    }
    
    funcArray(n);
    for(i=0;i<n;++i)
    {
        k3[i] = h * f[i];
        x[i] = xt[i] + k3[i];
    }
    
    t = t + h / 2;
    funcArray(n);
    for(i=0;i<n;++i)
    {
        k4[i] = h * f[i];
        x[i] = xt[i] + (k1[i] + 2*k2[i] + 2*k3[i] + k4[i]) / 6;
    }
}/* rkn */

int main(int argc, const char * argv[])
{
    long        i, j, n;
    long        skipNum=10, iterNum;
    fp          h, tStop, temp;
    
    setUserPrec(16);
    setOutPrec(16);
    
    n = 2;
    t = 0;
    tStop = 10;
    h = ".01";
    temp = (tStop - t) / h;
    iterNum = to_long(temp);
    
    f = (fp*)malloc(n*sizeof(fp));
    x = (fp*)malloc(n*sizeof(fp));
    xt = (fp*)malloc(n*sizeof(fp));
    k1 = (fp*)malloc(n*sizeof(fp));
    k2 = (fp*)malloc(n*sizeof(fp));
    k3 = (fp*)malloc(n*sizeof(fp));
    k4 = (fp*)malloc(n*sizeof(fp));
    
    for(i=0;i<n;++i)
    {
        init(f[i]);
        init(x[i]);
        init(xt[i]);
        init(k1[i]);
        init(k2[i]);
        init(k3[i]);
        init(k4[i]);
    }
    x[0] = 0; // for sine
    x[1] = 1;
    funcArray(n);
    
    cout << t << endl;
    for(j=0;j<n;++j)
        cout << x[j] << ", " << f[j] << endl;
    cout << endl;
    
    for (i=1;i<=iterNum;++i)
    {
        rkn(n, h);
        if((i/skipNum)*skipNum==i)
        {
            cout << t << endl;
            cout << x[0] << ", " << f[0] << endl;
            cout << x[1] << ", " << f[1] << endl;
            cout << endl;
        }
    }
    
    return 0;
}
// something bad happens between t = 3.14 and t = 3.15.
